<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://jsahu.me
 * @since             1.0.0
 * @package           Odia_Font_Converter
 *
 * @wordpress-plugin
 * Plugin Name:       Odia Font Converter
 * Plugin URI:        https://jsahu.me
 * Description:       Odia ASCII to Unicode Font Converter
 * Version:           1.0.0
 * Author:            Jnanaranjan Sahu - Gyana
 * Author URI:        https://jsahu.me
 * Text Domain:       odia-font-converter
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'ODIA_FONT_CONVERTER_VERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-odia-font-converter-activator.php
 */
function activate_odia_font_converter() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-odia-font-converter-activator.php';
	Odia_Font_Converter_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-odia-font-converter-deactivator.php
 */
function deactivate_odia_font_converter() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-odia-font-converter-deactivator.php';
	Odia_Font_Converter_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_odia_font_converter' );
register_deactivation_hook( __FILE__, 'deactivate_odia_font_converter' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-odia-font-converter.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_odia_font_converter() {

	$plugin = new Odia_Font_Converter();
	$plugin->run();

}
run_odia_font_converter();

// hooks your functions into the correct filters
function ouc_add_mce_button() {
	// check user permissions
	if ( !current_user_can( 'edit_posts' ) &&  !current_user_can( 'edit_pages' ) ) {
		return true;
	}
	// check if WYSIWYG is enabled
	if ( 'true' == get_user_option( 'rich_editing' ) ) {
		add_filter( 'mce_external_plugins', 'ouc_add_tinymce_plugin' );
		add_filter( 'mce_buttons', 'ouc_register_mce_button' );
	}
}
add_action('admin_head', 'ouc_add_mce_button');

// register new button in the editor
function ouc_register_mce_button( $buttons ) {
	array_push( $buttons, 'ouc_mce_dropdown', 'ouc_mce_button' );
	return $buttons;
}


// declare a script for the new button
// the script will insert the shortcode on the click event
function ouc_add_tinymce_plugin( $plugin_array ) {
	$plugin_array['ouc_mce_dropdown'] = plugins_url() .'/odia-font-converter/public/js/ouc.js';
	$plugin_array['ouc_mce_button'] = plugins_url() .'/odia-font-converter/public/js/ouc.js';
	return $plugin_array;
}